﻿using System;
using System.Windows;

abstract class FirefighterBase : INamedPerson, ISettableNamedPerson, ISalariedPerson
{
    public string Name
    {
        get;
        set;
    }
    public decimal Salary
    {
        get;
        set;
    }
    
    public abstract void ExtinguishFire();


    public void Drive(Firetruck truckToDrive, Point coordinates)
    {
        if (truckToDrive.Driver != this)
        {
            // Nie możemy prowadzić wozu strażackiego, jeśli nie jesteśmy kierowcą.
            return;
        }
        truckToDrive.Drive(coordinates);
    }
}